/* BSD license throughout
 * Ville Timonen, 2015
 * wili@wili.cc
 */
#include "imgwriter.h"
#include <png.h>
#include <stdlib.h>

void writeImage( int w, int h, int* pXY, float *pBias, std::string fName )
{
	png_structp pngPtr = png_create_write_struct( PNG_LIBPNG_VER_STRING, NULL, NULL, NULL );
	png_infop infoPtr = png_create_info_struct( pngPtr );
	setjmp( png_jmpbuf( pngPtr ) );

	if( !pngPtr || !infoPtr )
	{
		fprintf( stderr, "Failed to init libpng\n" );
		exit( 2 );
	}

	png_set_IHDR( pngPtr, infoPtr, w, h,
			8, PNG_COLOR_TYPE_RGB, PNG_INTERLACE_NONE,
			PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT );

	FILE *fp = fopen( fName.c_str(), "w" );
	if( !fp )
	{
		fprintf( stderr, "Couldn't open file\n" );
		exit( 3 );
	}
	
	png_init_io( pngPtr, fp );

	if( setjmp( png_jmpbuf( pngPtr ) ) )
	{
		fprintf( stderr, "Error while writing png\n" );
		exit( 4 );
	}

	png_write_info( pngPtr, infoPtr );

	if( setjmp( png_jmpbuf( pngPtr ) ) )
	{
		fprintf( stderr, "Error while writing png\n" );
		exit( 5 );
	}

	png_bytep *rowPtrs;
	rowPtrs = ( png_bytep* )malloc( sizeof( png_bytep ) * h );

	for( int i = 0; i < h; ++i )
	{
		unsigned char *data = (unsigned char *)malloc( sizeof( unsigned char ) * 3 * w );
		rowPtrs[i] = data;
		for( int x = 0; x < w; ++x )
		{
			int iIndex = i * w + x;
			*(data++) = (unsigned char)(pXY[ iIndex * 2 + 0 ]);
			*(data++) = (unsigned char)(pXY[ iIndex * 2 + 1 ]);
			
			if( pBias )
				*(data++) = (unsigned char)( pBias[ iIndex ] * 255.0f + 0.5f );
			else
				*(data++) = 0;
		}
	}

	png_write_image( pngPtr, rowPtrs );
	
	if( setjmp( png_jmpbuf( pngPtr ) ) )
	{
		fprintf( stderr, "Error while writing png\n" );
		exit( 6 );
	}

	png_write_end( pngPtr, NULL );

	for( int r = 0; r < h; ++r )
		free( rowPtrs[r] );

	free( rowPtrs );
	fclose( fp );
}
