/* BSD license throughout
 * Ville Timonen, 2015
 * wili@wili.cc
 */
#ifndef __POINT_H
#define __POINT_H

#include <vector>

#define INTEGRATION_STEPS 10 

float getDensity( float );

class Point 
{
	public:
		Point( int x, int y );
		Point( float x, float y );
		float linearDistanceFromCenter();
		float distanceFromCenter();
		float distanceFrom( const Point &p );
		float linearDistanceFrom( const Point &p );
		Point getEdgePoint();
		bool isWithinRadius();
		int getX() const;
		int getY() const;
		float getXf() const;
		float getYf() const;
		void setPos( float x, float y );
		void setWeight( float w );
		float getWeight();

		bool operator==( const Point &p );

		static void setCenter( float c );
		static void setSampleSize( int s );

	private:
		int m_iX;
		int m_iY;
		float m_fX;
		float m_fY;
		float m_fWeight;
		static float s_fCenter;
		static int s_iSampleSize;
};

class PointSet
{
	public:
		PointSet(); // const int iNumPoints );
		Point addPoint();
		void fillPoints( const int iColor, const int iSampleSize, int *pColorTable, int *pSampleTable );
		void pushPoint( Point p );
		Point getPoint( int i ) const;
		int getPointCount() const;
		PointSet subSet( int iPoints );
		void removePoints( const PointSet &p );
		void removePoints();
		void removePoint( Point p );
		Point getNearestLinear( Point p );
		void transferPointTo( PointSet *dest );
		static void setSampleSize( int s );
		void calculateWeights();

	private:
		std::vector< Point > m_points;
		static int s_iSampleSize;
};

#endif
