#ifndef _GPGPU_H
#define _GPGPU_H

#include <string>
#include <map>

#include "config.h"
#include "kernelCommon.h"

#include "sweep.h"
#include "oppositeCombine.h"
#include "accumulate.h"
#include "lineIndex.h"

#include "opengl.h"

namespace SSEO {

	class SSEOController {
		public:
		SSEOController(unsigned int, 
				unsigned int, 
				unsigned int, 
				Matrix4, 
				int, 
				int,
				int, 
				float,	
				GPGPU_Backend);

		static SSEOConfiguration *genConfig(int w, int h, int borderW, int borderH, int K, float falloffDecay);
		void execute(bool report);
		void *getResultBuf();
		~SSEOController();

		private:
		int d_liMem, d_lineIndexMem, d_lineContribMem, d_sweepBuffer, d_mirrorBuffer;
		int d_sweepSurface; // Used when sweepSurface() = true, otherwise d_sweepBuffer is used
		int d_sweepKernel, d_oppositeKernel, d_accKernel;
		int d_resultMem;
		int d_resultTex;
		Matrix4 d_projection;
		int d_frameCounter;
		double d_time;
		gpgpuController *d_gpgpuCtrl;

		double getTime();
		void exportLayerData();

		void initHBAO();
		void executeHBAO();

		unsigned int d_glDepthNormalTex, d_glNormalTex, d_glResultTex;
		unsigned int d_hbaoFBO;
		Shader *d_hbaoShader;
		ShaderData *d_hbaoShaderData;
		Texture *d_depthNormalTex, *d_normalTex;

		SSEOConfiguration *d_config;

		GPGPU_Backend d_backend;
	};

	extern SSEOController *g_sseoCtrl;
};

#endif // _GPGPU_H
