#include "hbao.h"
#include "opengl.h"
#include "control.h"
#include <cmath>

HBAOShader::HBAOShader() {
}

//#define USE_ORIG_FALLOFF
#define EYESTEP

#define MAXOCC // For mode() == 3, don't pick the largest horizon but rather largest occlusion

void HBAOShader::genSrc() {
	/*if (d_config->tangentType() == 1)
		d_config->tangentType() = 2;*/

	// From tangents, we support:
	// 0, 3, which are the same as in LSAO
	// 1  Choose the minimum tilt from one step backwards and one forwards (best quality)
	// 2  Read the smallest tilt from next x/y (the same as the original)

	bool prereadNormal = d_config->tangentType() != 0 && d_config->tangentType() != 1;

	append("in vec2 myTexCoord;\n");
	append("uniform sampler2D depthTex;\n");
	append("uniform sampler2D normalTex;\n");
	append("out float occlusionOut;\n");

	float borderSideW = (d_config->hfWidth() - d_config->occWidth())/2;
	float borderSideH = (d_config->hfHeight() - d_config->occHeight())/2;

	float alpha = d_config->projMatrix().elem(0,0);
	float beta = d_config->projMatrix().elem(1,1);
	float A = d_config->projMatrix().elem(2,0);
	float B = d_config->projMatrix().elem(2,1);
	float a = (1.0f-A)/alpha;
	float b = -2.0f/((float)d_config->hfWidth()*alpha);
	float c = (1.0f-B)/beta;
	float d = -2.0f/((float)d_config->hfHeight()*beta);

	append("vec3 unProj(vec2 screenPos, float height) {\n");
	append("  return vec3((%E + screenPos.x*%E)*height, (%E + screenPos.y*%E)*height, height);\n", a, b, c, d);
	append("}\n");

	append("bool insideTex(vec2 pos) {\n");
	append("  return ((pos.x > %E) && (pos.x < %E) && (pos.y > %E) && (pos.y < %E));\n", 
			0.5f, (float)d_config->hfWidth() - 0.5f, 
			0.5f, (float)d_config->hfHeight() - 0.5f);
	append("}\n\n");

	/*append("vec3 unProj(vec2 screenPos, float height) {\n");
	append("  return vec3((%E + screenPos.x*%E)*height, (%E + screenPos.y*%E)*height, height);\n", a, b, c, d);
	append("}\n");*/
	append("vec2 snapCoord(const vec2 inCoord) {\n");
	append("  return vec2(float(int(inCoord.x*%E))*%E + %E, float(int(inCoord.y*%E))*%E + %E);\n",
			(float)d_config->hfWidth(),
			1.0f/(float)d_config->hfWidth(), 0.5f/(float)d_config->hfWidth(),
			(float)d_config->hfHeight(),
			1.0f/(float)d_config->hfHeight(), 0.5f/(float)d_config->hfHeight());
	append("}\n\n");

	//append("const float falloffCoef = 0.5;\n");
	append("float vecFalloff(vec2 horVec) {\n");

	#define CUTOFF 0.3f

	#ifdef USE_ORIG_FALLOFF
	append("  return max(0.0, 1.0 - falloffCoef*length(horVec));\n");
	#else
	append("  const float invCoef = %E;\n", 1.0f/d_config->fallOff());
	append("  return max(0.0, %E/(1.0 + invCoef*dot(horVec, horVec)) - %E);\n", 1.0f + CUTOFF, CUTOFF);
	//append("  return 1.0/(1.0 + invCoef*dot(horVec, horVec));\n");
	#endif
	append("}\n\n");

	append("void main() {\n");
	incrementIndent();
	append("int tidX = int(myTexCoord.x*%E);\n", (float)d_config->occWidth());
	append("int tidY = int(myTexCoord.y*%E);\n", (float)d_config->occHeight());
	append("vec2 myPos = vec2(%E + float(tidX), %E - float(tidY));\n", 
			0.5f + borderSideW, (float)d_config->hfHeight()-0.5f - borderSideH);

	/*
	append("float myHeight = texture(depthTex, vec2(myPos.x*%E, myPos.y*%E)).x;\n",	
			1.0f/(float)d_config->hfWidth(), 1.0f/(float)d_config->hfHeight());
	*/

	append("occlusionOut = 0.0;\n");

	float angleOffset = 2.0f*PI/(float)d_config->dirs();
	float angle0 = d_config->dirOffset();

	/*append("vec2 pLocalXY;\n");
	append("float pLocalHeight;\n");*/

	append("const vec2 texCoordNormalizer = vec2(%E, %E);\n",
				1.0f/(float)d_config->hfWidth(), 1.0f/(float)d_config->hfHeight());

	append("vec3 pLocalSource;\n");
	if (prereadNormal)
		append("vec3 nLocalSource;\n");
	append("{\n");
	incrementIndent();

	//if (d_config->stepInterpolation() == 0)
		append("vec2 tempCoord = myPos*texCoordNormalizer;\n");	/*else if (d_config->stepInterpolation() == 1)
		append("vec2 tempSnapCoord = snapCoord(myPos*vec2(%E, %E));\n",
				1.0f/(float)d_config->hfWidth(), 1.0f/(float)d_config->hfHeight());*/

		append("pLocalSource = unProj(myPos, texture(depthTex, tempCoord).x);\n");
	/*append("pLocalHeight = texture(depthTex, tempCoord).x;\n"); //vec2(tempSnapCoord.x*%E, tempSnapCoord.y*%E)).x;\n", 
			//1.0f/(float)d_config->hfWidth(), 1.0f/(float)d_config->hfHeight());
	append("pLocalXY = vec2(%E + %s.x*%E, %E + %s.y*%E);\n",
			a, "tempCoord", (float)d_config->hfWidth()*b, 
			c, "tempCoord", (float)d_config->hfHeight()*d);*/


	if (d_config->tangentType() == 3)
		append("nLocalSource = texture(normalTex, tempCoord).xyz;\n");
	else if (d_config->tangentType() == 2) {
		// We'll just "manually" take the 4 samples..
		/*append("{\n");
		incrementIndent();*/
		//append("vec2 coordCoef = vec2(%E, %E);\n", 1.0f/(float)d_config->hfWidth(), 1.0f/(float)d_config->hfHeight());
		append("vec2 tempCoordL = myPos + vec2(-1.0, 0.0);\n");
		append("vec2 tempCoordR = myPos + vec2(1.0, 0.0);\n");
		append("vec2 tempCoordT = myPos + vec2(0.0, -1.0);\n");
		append("vec2 tempCoordB = myPos + vec2(0.0, 1.0);\n");
		append("vec3 sampleL = unProj(tempCoordL, texture(depthTex, tempCoordL*texCoordNormalizer).x);\n");
		append("vec3 sampleR = unProj(tempCoordR, texture(depthTex, tempCoordR*texCoordNormalizer).x);\n");
		append("vec3 sampleT = unProj(tempCoordT, texture(depthTex, tempCoordT*texCoordNormalizer).x);\n");
		append("vec3 sampleB = unProj(tempCoordB, texture(depthTex, tempCoordB*texCoordNormalizer).x);\n");

		#if 1
		append("vec3 tiltX = length(sampleL - pLocalSource) < length(pLocalSource - sampleR) ? (sampleL - pLocalSource) : (pLocalSource - sampleR);\n");
		append("vec3 tiltY = length(sampleT - pLocalSource) < length(pLocalSource - sampleB) ? (sampleT - pLocalSource) : (pLocalSource - sampleB);\n");
		#else
		append("vec3 tiltX = sampleL - sampleR;\n");
		append("vec3 tiltY = sampleT - sampleB;\n");
		#endif
		append("nLocalSource = cross(tiltX, tiltY);\n");
	}

	decrementIndent();
	append("}\n"); // Taking a sample


	#ifdef EYESTEP	
	// Now we calculate the actual step size..

	#if 0
	// This is how long the step has to be to cover the full range
	//append("const float eyeStep = 1.0/(%E*falloffCoef);\n", (float)d_config->hbaoSteps());
	float maxDist = sqrtf(1.0f/CUTOFF*d_config->fallOff()) * 0.5f;
	//float maxDist = sqrtf(1.0f*d_config->fallOff());
	append("const float eyeStep = %E;\n", maxDist/(float)d_config->hbaoSteps());
	// This is how long one pixel-long step is in eye-space with this depth
	append("const float pixelStep = pLocalSource.z*%E;\n", b);
	// And this is the correction coefficient..
	append("const float stepCoef = eyeStep/pixelStep;\n");
	#else
	//append("const float stepCoef = 1.0/(%E*falloffCoef*pLocalSource.z);\n", (float)d_config->hbaoSteps()*b);
	float maxDist = sqrtf(d_config->fallOff()/CUTOFF);
	append("const float stepCoef = %E/pLocalSource.z;\n", maxDist/(float)d_config->hbaoSteps()/b * 0.5f);
	#endif // 0

	#endif // EYESTEP



	//append("float tempDif;\n");

	append("\n\n");
	append("for (int dir = 0; dir < %d; ++dir) {\n", d_config->dirs());
	//append("for (int dir = 1; dir < 2; ++dir) {\n", d_config->dirs());
	incrementIndent();
	append("float occlusion = 0.0;\n");
	append("vec2 dirStep;\n");
	append("{\n");
	incrementIndent();
	append("float angle = %E + float(dir)*%E;\n", angle0+PI, angleOffset);
	append("dirStep.x = sin(angle);\n");
	append("dirStep.y = cos(angle);\n");
	decrementIndent();
	append("}\n");

	append("vec2 samplePos;\n");

	append("float tangentSin;\n");

	//append("vec2 pLocal = vec2((pLocalXY.x*dirStep.x + pLocalXY.y*dirStep.y)*pLocalHeight, pLocalHeight);\n");
	append("vec2 pLocal = vec2(dot(pLocalSource.xy, dirStep), pLocalSource.z);\n");
	append("vec2 upVec = normalize(-pLocal);\n");
	if (prereadNormal)
		//append("vec2 nLocal = normalize(vec2(nLocalSource.x*dirStep.x + nLocalSource.y*dirStep.y, nLocalSource.z));\n");
		append("vec2 nLocal = normalize(vec2(dot(nLocalSource.xy, dirStep), nLocalSource.z));\n");

	else if (d_config->tangentType() == 1) {
		append("vec2 nextPos = myPos - dirStep;\n");
		append("vec2 prevPos = myPos + dirStep;\n");
		/*append("vec2 nextPos = snapCoord((myPos - dirStep)*texCoordNormalizer);\n");
		append("vec2 prevPos = snapCoord((myPos + dirStep)*texCoordNormalizer);\n");*/
		append("vec3 nextPoint = unProj(nextPos, texture(depthTex, nextPos*texCoordNormalizer).x);\n");
		append("vec3 prevPoint = unProj(prevPos, texture(depthTex, prevPos*texCoordNormalizer).x);\n");

		append("vec3 slopeVec;\n");
		append("if (length(nextPoint - pLocalSource) < length(pLocalSource - prevPoint)) {\n");
		append("  slopeVec = nextPoint - pLocalSource;\n");
		//append("  tangentSin = dot(upVec, normalize(vec2(dot(slopeVec.xy, dirStep), slopeVec.z)));\n");
		append("  // We can go forward now..   for a small optimization\n");
		append("  samplePos = myPos - dirStep*stepCoef*2.0;\n");
		append("} else {\n");
		append("  slopeVec = pLocalSource - prevPoint;\n");
		append("  samplePos = myPos - dirStep*stepCoef;\n");
		append("}\n");
		append("tangentSin = dot(upVec, normalize(vec2(dot(slopeVec.xy, dirStep), slopeVec.z)));\n");
	}

	if (d_config->tangentType() != 1) {
		#ifdef EYESTEP
		append("samplePos = myPos - dirStep*stepCoef;\n");
		#else
		append("samplePos = myPos - dirStep*%E;\n", d_config->hbaoStepLen());
		#endif
	}


	//append("dirStep *= %E;\n", d_config->hbaoStepLen());
	//#define MIMIC_LSAO

	if (d_config->tangentType() != 0) {
		if (d_config->tangentType() != 1) {
			append("tangentSin = upVec.x*-nLocal.y + upVec.y*nLocal.x;\n");
			#ifdef MIMIC_LSAO
			append("tangentSin = %E;\n", d_config->fixedTangent());
			#endif
		}
	} else if (d_config->tangentType() == 0)
		append("tangentSin = %E;\n", d_config->fixedTangent());
	else // Lel, kek bur
		throw std::string("TangentType() not supported");

	append("float maxSlope = tangentSin;\n");
	#ifdef MAXOCC
	if (d_config->mode() == 3)
		append("maxSlope = 0.0; // We expect the compiler to ignore the previous assignment as an optimization\n");
	#endif
	append("occlusion = tangentSin;\n");

	if (d_config->mode() == 3)
		append("vec2 maxV1;\n");

	// We could get rid of one sample in case tangentType() == 1 and the tangent was found
	// from the next step, but it doesn't always come from the next step..
	append("for (int stepC = 0; stepC < %d && insideTex(samplePos); ++stepC) {\n", d_config->hbaoSteps());
			//d_config->tangentType() == 1 ? d_config->hbaoSteps()-1 : d_config->hbaoSteps());
	incrementIndent();


	/* Sample START */
	append("vec2 samplePoint;\n");
	append("{\n");
	incrementIndent();
	
	if (d_config->stepInterpolation() == 0)
		append("vec2 tempSnapCoord = samplePos*texCoordNormalizer;\n"); //vec2(%E, %E);\n",
		//		1.0f/(float)d_config->hfWidth(), 1.0f/(float)d_config->hfHeight());
	else if (d_config->stepInterpolation() == 1)
		append("vec2 tempSnapCoord = snapCoord(samplePos*texCoordNormalizer);\n"); //vec2(%E, %E));\n",
		//		1.0f/(float)d_config->hfWidth(), 1.0f/(float)d_config->hfHeight());
	else
		throw std::string("Unsupported stepInterpolation()");

	append("float height = texture(depthTex, tempSnapCoord).x;\n"); //vec2(tempSnapCoord.x*%E, tempSnapCoord.y*%E)).x;\n", 
			//1.0f/(float)d_config->hfWidth(), 1.0f/(float)d_config->hfHeight());
	append("vec2 projXY = vec2(%E + %s.x*%E, %E + %s.y*%E);\n",
			a, "tempSnapCoord", (float)d_config->hfWidth()*b, 
			c, "tempSnapCoord", (float)d_config->hfHeight()*d);
	append("samplePoint = vec2((projXY.x*dirStep.x + projXY.y*dirStep.y)*height, height);\n");
	decrementIndent();
	append("}\n");
	/* Sample END */

	append("vec2 v1 = samplePoint - pLocal;\n");

	append("float thisSlope = dot(normalize(v1), upVec);\n");

	#ifdef MIMIC_LSAO
	append("thisSlope = (1.0 + thisSlope)*vecFalloff(v1);\n");
	#endif

	#ifdef MAXOCC
	if (d_config->mode() == 3)
		append("thisSlope = (thisSlope - tangentSin)*vecFalloff(v1);\n");
	#endif

	append("if (thisSlope > maxSlope) {\n");
	#ifndef MIMIC_LSAO
	if (d_config->mode() == 4)
		append("  occlusion += (thisSlope - maxSlope)*vecFalloff(v1);\n");
	else
		#ifndef MAXOCC
		append("  maxV1 = v1;\n")
		#endif
		;

	#endif
	append("  maxSlope = thisSlope;\n");
	append("}\n");
	
	#ifdef EYESTEP
	append("samplePos -= dirStep*stepCoef;\n");
	#else
	append("samplePos -= dirStep*%E;\n", d_config->hbaoStepLen());
	#endif
	//append("occlusion = 0.1*length(upVec);\n"); //samplePoint.y;\n");

	/*append("vec3 deProj = unProj(myPos, pLocalHeight);\n");
	append("vec2 pLocalNew = vec2(dirStep.x*deProj.x + dirStep.y*deProj.y, deProj.z);\n");
	append("vec2 difVec = pLocal - pLocalNew;\n");
	append("tempDif = dot(difVec, difVec);\n"); // - (unProj(myPos, pLocalHeight)*/

	decrementIndent();
	append("}\n"); // foreach step

	if (d_config->mode() == 3)
		#ifdef MAXOCC
		append("occlusion += maxSlope; // maxSlope here is actually maxOcclusion\n"); 
		#else
		append("occlusion += (maxSlope - occlusion)*vecFalloff(maxV1); // occlusion prior to this is tangentSin\n");
		#endif

	#ifdef MIMIC_LSAO
	append("occlusion = -1.0 + maxSlope;\n");
	#endif

	append("occlusionOut += occlusion;\n");

	decrementIndent();
	append("}\n"); // foreach dir

	append("occlusionOut = 1.0 - occlusionOut*%E;\n", 1.0f/(float)d_config->dirs());

	//append("occlusionOut = tempDif;\n");

	decrementIndent();
	append("}\n");
}

void SSEOController::initHBAO() {
	// In order to fill the result texture, we have to create a fbo out of it
	glGenFramebuffers(1, &d_hbaoFBO);
	glBindFramebuffer(GL_DRAW_FRAMEBUFFER, d_hbaoFBO);
	glFramebufferTexture2D(GL_DRAW_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_2D, d_glResultTex, 0);
	OpenGLController::checkErrors("FBO creation");

	// FIXME: There are two texture modes now..
	// Creating our Textures out of the GL ones
	d_normalTex = new Texture(GL_TEXTURE_2D, d_glNormalTex, "normal");
	d_depthNormalTex = new Texture(GL_TEXTURE_2D, d_glDepthNormalTex, "depthNormal");

	// Now this is slightly fancy..  We generate the sources for the OpenGL shader using 
	// the GPGPU framework..  Just that we can complete the code in a same way..  Then we write it out
	// and read using OpenGL framework

	HBAOShader fragShader;
	fragShader.setConfig(d_config);
	fragShader.setKeywords(new fragKeywords());
	fragShader.write("shaders/hbao");

	try {
		d_hbaoShader = g_defaultShaderPool->getShader("hbao");
		d_hbaoShaderData = new ShaderData(d_hbaoShader);
		d_hbaoShaderData->addTexture("depthTex", d_depthNormalTex); 
		d_hbaoShaderData->addTexture("normalTex", d_normalTex);
		GLfloat texCoord[] = { 
			0.0f, 1.0f, 
			0.0f, 0.0f,
			1.0f, 1.0f,
			1.0f, 0.0f
		};
		d_hbaoShaderData->addVData("texCoord", GL_FLOAT, 2, 4, texCoord);
		d_hbaoShaderData->addVData("pos", GL_FLOAT, 2, 4, texCoord);
	} catch (std::string e) {
		fprintf(stderr, "Trying to init HBAO: %s\n", e.c_str());
		exit(111);
	}

	if ((d_config->hfWidth() - d_config->occWidth())&1 ||
			(d_config->hfHeight() - d_config->occHeight())&1)
		throw std::string("Borders not divisible by 2 o_O");

	d_depthNormalTex->bind();
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
}

void SSEOController::executeHBAO() {
	static int frameCounter = 0;
	static double totalRuntime = 0.0;

	int borderW2 = (d_config->hfWidth() - d_config->occWidth())/2;
	int borderH2 = (d_config->hfHeight() - d_config->occHeight())/2;

	glFinish();
	double startTime = getTime();

	glBindFramebuffer(GL_DRAW_FRAMEBUFFER, d_hbaoFBO);
	// No depth testing
	glDisable(GL_DEPTH_TEST);
	glViewport(borderW2, borderH2, d_config->occWidth(), d_config->occHeight());
	
	d_hbaoShaderData->shader()->activate();
    d_hbaoShaderData->bind();
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

	glFinish();
	OpenGLController::checkErrors("Execute HBAO end");

	totalRuntime += getTime() - startTime;
	frameCounter++;
	
	// Reporting "accumulated" time
	if (!(frameCounter%10))	{
		printf("HBAO runs in %.3f ms\n", totalRuntime*1000.0/(double)frameCounter);
		totalRuntime = 0.0;
		frameCounter = 0;
	}
}
