#ifndef _HOSTTYPES_H
#define _HOSTTYPES_H

namespace SSEO {
	enum GPGPU_Backend { SSEO_OPENCL, SSEO_CUDA };

	class double2;

	class float2 {
		public:
		float2(float nx = 0.0f, float ny = 0.0f);
		float2 operator+(const float2);
		float2 operator-(const float2);
		float2 operator-();
		operator double2();
		void operator+=(const float2);
		void operator-=(const float2);
		float2 operator*(const float);
		void operator*=(const float);
		void operator*=(const float2);
		bool operator==(const float2);
		bool operator!=(const float2);
		float dot(const float2 b);
		// This is for sorting rays
		static bool lowerX(const float2 a, const float2 b);

		float x, y;
	};

	class double2 {
		public:
		double2(double nx = 0.0, double ny = 0.0);
		//double2(float nx = 0.0f, float ny = 0.0f);
		operator float2();
		double2 operator+(const double2);
		double2 operator-(const double2);
		double2 operator-();
		void operator+=(const double2);
		void operator-=(const double2);
		double2 operator*(const double);
		void operator*=(const double);
		bool operator==(const double2);
		bool operator!=(const double2);
		double dot(const double2 b);
		// This is for sorting rays
		static bool lowerX(const double2 a, const double2 b);
		float length();

		double x, y;
	};

	class float3 {
		public:
		float3(float x = 0.0f, float y = 0.0f, float z = 0.0f);
		float x() const;
		float y() const;
		float z() const;
		void x(float);
		void y(float);
		void z(float);

		void operator+=(const float3 add);
		float3 operator-(const float3 sub);
		void normalize();
		float3 cross(const float3 b);

		static void normalize(float&, float&, float&);

		private:
		float d_x, d_y, d_z;
	};


	class Matrix4 {
		public:
		Matrix4();
		Matrix4(const Matrix4 &c);
		float *data();
		float *colMajorData();

		void invert();
		float determinant();

		void translate(float, float, float);
		void rotate(float, float, float, float);
		void perspective(float, float, float, float, float, float);

		const float elem(int, int) const;
		float &elem(int, int);

		Matrix4 operator*(const Matrix4 B);
		Matrix4 &operator=(const Matrix4 &n);

		void print();

		private:
		float d_data[16];
		float d_colMajorData[16];
	};

	class Matrix3 {
		public:
		Matrix3(const Matrix4);
		float *data();
		float *colMajorData();

		private:
		float d_data[9];
		float d_colMajorData[9];
	};
};

#endif // _HOSTTYPES
