#include "kernelCommon.h"

using namespace SSEO;

SSEOKernelSrc::SSEOKernelSrc() : 
	d_config(NULL)
{
}

void SSEOKernelSrc::setConfig(SSEOConfiguration *c) {
	d_config = c;
}

void SSEOKernelSrc::genCommonFunctions() {
	float alpha = d_config->projMatrix().elem(0,0);
	float beta = d_config->projMatrix().elem(1,1);
	float A = d_config->projMatrix().elem(2,0);
	float B = d_config->projMatrix().elem(2,1);
	float a = (1.0f-A)/alpha;
	float b = -2.0f/((float)d_config->hfWidth()*alpha);
	float c = (1.0f-B)/beta;
	float d = -2.0f/((float)d_config->hfHeight()*beta);

	append(d_keywords->funcDecl("unProj", "float3", "const float2 screenPos, const float height"));
	append(" {\n  return %s;\n",
			d_keywords->float3Ctor(genStr("(%Ef + screenPos.x*%Ef)*height", a, b),
				genStr("(%Ef + screenPos.y*%Ef)*height", c, d), "height").c_str());
	append("}\n");

	a = alpha*(float)d_config->hfWidth()/-2.0f;
	b = (A/-2.0f + 0.5f)*(float)d_config->hfWidth();
	c = beta*(float)d_config->hfHeight()/-2.0f;
	d = (B/-2.0f + 0.5f)*(float)d_config->hfHeight();

	append(d_keywords->funcDecl("proj", "float2", "const float3 eyePos"));
	append(" {\n  float invZ = %s;\n",
			d_keywords->div("1.0f", "eyePos.z").c_str());
	append("  return %s;\n",
			d_keywords->float2Ctor(genStr("%Ef*invZ*eyePos.x + %Ef", a, b),
				genStr("%Ef*invZ*eyePos.y + %Ef", c, d)).c_str());
	append("}\n");

	append(d_keywords->funcDecl("insideTex", "bool", "const float2 pos"));

	float xCoef = 1.0f/(float)d_config->hfWidth();
	float yCoef = 1.0f/(float)d_config->hfHeight();

	append(" {\n  return (pos.x > %Ef && pos.x < %Ef && pos.y > %Ef && pos.y < %Ef);\n}\n\n",
			//0.5f, (float)d_config->hfWidth() - 0.5f, 0.5f, (float)d_config->hfHeight() - 0.5f);
			0.5f*xCoef, ((float)d_config->hfWidth() - 0.5f)*xCoef, 
			0.5f*yCoef, ((float)d_config->hfHeight() - 0.5f)*yCoef);
}


SSEOConfiguration::SSEOConfiguration() {}

int &SSEOConfiguration::mode() { return d_mode; }
int &SSEOConfiguration::hbaoSteps() { return d_hbaoSteps; }
float &SSEOConfiguration::hbaoStepLen() { return d_hbaoStepLen; }
float &SSEOConfiguration::fallOff() { return d_fallOff; }
bool &SSEOConfiguration::optiPath() { return d_optiPath; }
int &SSEOConfiguration::unrollAmount() { return d_unrollAmount; }
int &SSEOConfiguration::unrollStorage() { return d_unrollStorage; }
int &SSEOConfiguration::hullStorage() { return d_hullStorage; }
bool &SSEOConfiguration::stopAtMax() { return d_stopAtMax; }
int &SSEOConfiguration::hullSize() { return d_hullSize; }
int &SSEOConfiguration::hullType() { return d_hullType; }
int &SSEOConfiguration::hullThresholdType() { return d_hullThresholdType; }
float &SSEOConfiguration::hullThreshold() { return d_hullThreshold; }
int &SSEOConfiguration::dirs() { return d_dirs; }
float &SSEOConfiguration::dirOffset() { return d_dirOffset; }
bool &SSEOConfiguration::usePreset() { return d_usePreset; }
bool &SSEOConfiguration::gatherBuffer() { return d_gatherBuffer; }
bool &SSEOConfiguration::matchOpposite() { return d_matchOpposite; }
bool &SSEOConfiguration::useV4Buffers() { return d_useV4Buffers; }
bool &SSEOConfiguration::useHalfBuffers() { return d_useHalfBuffers; }
int &SSEOConfiguration::hfWidth() { return d_hfWidth; }
int &SSEOConfiguration::hfHeight() { return d_hfHeight; }
int &SSEOConfiguration::occWidth() { return d_occWidth; }
int &SSEOConfiguration::occHeight() { return d_occHeight; }
int &SSEOConfiguration::sweepStripe() { return d_sweepStripe; }
int &SSEOConfiguration::sweepStorageStripe() { return d_sweepStorageStripe; }
int &SSEOConfiguration::sweepBlock() { return d_sweepBlock; }
int &SSEOConfiguration::stepInterpolation() { return d_stepInterpolation; }
int &SSEOConfiguration::tangentType() { return d_tangentType; }
float &SSEOConfiguration::fixedTangent() { return d_fixedTangent; }
int &SSEOConfiguration::sweepWidth() { return d_sweepWidth; }
int &SSEOConfiguration::sweepHeight() { return d_sweepHeight; }
bool &SSEOConfiguration::sweepSurface() { return d_sweepSurface; }
bool &SSEOConfiguration::occlusionScatter() { return d_occlusionScatter; }
int &SSEOConfiguration::accBlockX() { return d_accBlockX; }
int &SSEOConfiguration::accBlockY() { return d_accBlockY; }
int &SSEOConfiguration::edgeAwareAcc() { return d_edgeAwareAcc; }
float &SSEOConfiguration::edgeThreshold() { return d_edgeThreshold; }
bool &SSEOConfiguration::includeMin() { return d_includeMin; }
float &SSEOConfiguration::lineSkip() { return d_lineSkip; }
float &SSEOConfiguration::stepSkip() { return d_stepSkip; }
bool &SSEOConfiguration::jitterTangent() { return d_jitterTangent; }
int &SSEOConfiguration::linesPerPixel() { return d_linesPerPixel; }
bool &SSEOConfiguration::separateSources() { return d_separateSources; }
Matrix4 &SSEOConfiguration::projMatrix() { return d_projMatrix; }
