#ifndef _KERNELCOMMON_H
#define _KERNELCOMMON_H

#include <string>
#include <vector>
#include "hostTypes.h"
#include "gpgpu_frame.h"

namespace SSEO {
	class SSEOConfiguration {
		public:
		SSEOConfiguration();
		int 	&mode();
		int 	&hbaoSteps();
		float 	&hbaoStepLen();
		float 	&fallOff();
		bool 	&optiPath();
		int 	&unrollAmount();
		int 	&unrollStorage();
		int 	&hullStorage();
		bool 	&stopAtMax();
		int 	&hullSize();
		int 	&hullType();
		int 	&hullThresholdType();
		float 	&hullThreshold();
		int 	&dirs();
		float 	&dirOffset(); // Where does the first direction start (0.0 = axis-aligned, 1.0 = 2pi/dirs)
		bool 	&usePreset();
		bool 	&gatherBuffer();
		bool 	&matchOpposite(); // Make the +180 direction a perfect mirror
		bool 	&useV4Buffers();
		bool 	&useHalfBuffers();
		int 	&hfWidth();
		int 	&hfHeight();
		int 	&occWidth();
		int 	&occHeight();
		int 	&sweepStripe();
		int 	&sweepStorageStripe();
		int 	&sweepBlock();
		int 	&stepInterpolation(); // 0: linear, 1: snap, 2: edge-aware
		int 	&tangentType(); // 0: no tangent, 1: next-prev tangent, 2: next-prev min, 3: normal map
		float 	&fixedTangent();
		int 	&sweepWidth();
		int 	&sweepHeight();
		bool 	&sweepSurface();
		bool 	&occlusionScatter();
		int 	&edgeAwareAcc();
		float 	&edgeThreshold();
		bool 	&includeMin();
		int 	&accBlockX();
		int 	&accBlockY();
		float 	&lineSkip();
		float 	&stepSkip();
		bool 	&jitterTangent();
		int 	&linesPerPixel(); // How many "closest match" lines to select per pixel
		bool 	&separateSources(); // Whether height + normal textures are separate

		Matrix4 &projMatrix(); 		// The projection matrix as supplied by the application

		
		private:
		int d_mode, d_hbaoSteps;
		float d_hbaoStepLen, d_fallOff;
		bool d_optiPath;
		int d_unrollAmount, d_unrollStorage;
		int d_hullStorage;
		bool d_stopAtMax;
		int d_hullSize, d_hullType, d_hullThresholdType;
		float d_hullThreshold;
		int d_dirs;
		float d_dirOffset;
		bool d_usePreset, d_gatherBuffer, d_matchOpposite, d_useV4Buffers, d_useHalfBuffers;
		int d_hfWidth, d_hfHeight, d_occWidth, d_occHeight;
		int d_sweepStripe, d_sweepStorageStripe, d_sweepBlock, d_stepInterpolation, d_tangentType;
		float d_fixedTangent;
		int d_sweepWidth, d_sweepHeight;
		bool d_sweepSurface, d_occlusionScatter;
		int d_edgeAwareAcc;
		float d_edgeThreshold;
		bool d_includeMin;
		int d_accBlockX, d_accBlockY;
		int d_linesPerPixel;
		float d_lineSkip, d_stepSkip;
		bool d_jitterTangent, d_separateSources;
		Matrix4 d_projMatrix;
	};

	
	class SSEOKernelSrc : public KernelSrc {
		public:
		SSEOKernelSrc();
		void setConfig(SSEOConfiguration*);

		protected:
		SSEOConfiguration *d_config;
		void genCommonFunctions();
	};

};

#endif // _KERNELCOMMON_H
