#ifndef _LINEINDEX_H
#define _LINEINDEX_H

#include <vector>
#include <string>

#include "kernelCommon.h"

#include "hostTypes.h"
#include "sharedConstants.h"

using namespace SSEO;
#include "sharedStructs.h"


namespace SSEO {
	class LineIndex {
		public:
		LineIndex(SSEOConfiguration*);
		void setLI(std::vector<struct LineInfo>*);
		void setDirOffsets(std::vector<int>);
		size_t genData(unsigned int**);

		struct LineCandidate { // Obsolete
			int dirIndex;
			unsigned int globalLineIndex;
			unsigned int pixCoordX, pixCoordY;
			float distance;
			float coef;
		};

		struct PixCandidate {
			int dirIndex;
			unsigned int globalIndex;
			unsigned int pixCoordX, pixCoordY;
			unsigned int writeIndex; // Used for gatherBuffers
			float distance;
		};

		float2 snapCoord(float2); // Not static 'cause we need the config
		bool insideOcc(int, int);

		void updatePix(std::vector<struct PixCandidate>*, struct PixCandidate);
		void checkBounds(size_t);

		static bool lineCompare(struct LineCandidate, struct LineCandidate);
		static bool indexCompare(struct LineCandidate, struct LineCandidate);
		static bool lengthCompare(struct PixCandidate, struct PixCandidate);
		static bool dirCompare(struct PixCandidate, struct PixCandidate);
		static bool writeCompare(struct PixCandidate, struct PixCandidate);

		protected:
		SSEOConfiguration *d_config;
		std::vector<struct LineInfo> *d_lineInfos;
		std::vector<int> d_dirOffsets;
		std::vector<float> d_distOffsetCoefs;

		private:
		void optimizeWrites(std::vector<std::vector<std::vector<struct PixCandidate> > >*);
		void organizeBlock(std::vector<struct PixCandidate>*);
	};
};

#endif // _LINEINDEX_H
