#ifndef _OPENGL_H
#define _OPENGL_H

#define GL_GLEXT_PROTOTYPES
#define GLX_GLXEXT_PROTOTYPES

#include <X11/Xlib.h>
#include <GL/gl.h>
#include <GL/glx.h>

// These are obsolete in most distributions, hence provided explicitly.
#include "GL/glxext.h"
#include "GL/glext.h"

#include "hostTypes.h"

#include <string>
#include <list>
#include <vector>

namespace SSEO {
	class Texture;
	class ShaderData;
	class Mesh;

	class OpenGLController {
		public:
		OpenGLController(int, int, int, int, std::string Xdpy = ":0", int posX = 0, int posY = 0);
		~OpenGLController();

		Texture *getTestHF(float *data = NULL);
		Texture *getResultTex(int, int);
		void blit(Texture*);
		void swapBuffers();
		float *getFBData(size_t *size = NULL);
		void vomitFB(std::string fname); // Export frame buffer
		bool abort();

		void render();
		void setCamera(float x, float y, float z, float rotZ, float rotY);
		void updateCamera(); // From the controls
		void loadMesh(Mesh&);
		void initRendering(int genNormal);
		Texture *getHeight();
		Texture *getNormal();
		Texture *genNormalFromHeight();

		Matrix4 projMatrix();

		static void checkErrors(std::string msg = "");
		static int getTexParam(GLuint, GLenum);
		static int getTexWidth(GLuint);
		static int getTexHeight(GLuint);
		static int getTexChannels(GLuint);
		static int getTexComponentSize(GLuint);

		private:
		int d_winWidth, d_winHeight;
		bool d_abort;
		float d_borderFracW, d_borderFracH;
		ShaderData *d_blitShaderData;
		Texture *d_blitTex;
		Display *d_dpy;
		Window d_win;
		GLXContext d_ctx;

		int d_depthWidth, d_depthHeight;
		GLuint d_renderFbo, d_indexBuffer;
		ShaderData *d_renderShaderData;
		int d_meshPolys;
		Texture *d_heightTex;
		GLuint d_depthAttachTex;
		GLuint d_zeroBuffer; // The height tex is zeroed with this buffer
		Texture *d_normTex;
		ShaderData *d_normShaderData;
		GLuint d_normalFbo;
		int d_renderNormal;

		std::vector<float> d_cameraParams; // Just a hack..
		bool d_buttonPressed;
		void hideCursor();

		Matrix4 d_projMatrix;
	};

	class Mesh {
		public:
		Mesh();
		size_t polyCount();
		size_t vertCount();
		void genNormals();
		float *vertData();
		float *normData();
		int *indexData();
		void split(); // Split up all polygons
		void addFloor(bool);

		protected:
		std::vector<float> d_vertices;
		std::vector<float> d_normals;
		std::vector<int> d_indices;
		bool d_addFloor;
		float d_minZ;
	};

	class WavefrontObject : public Mesh {
		public:
		WavefrontObject(std::string fname);
		WavefrontObject();
		void loadFile(std::string fname);
		void coordExchange(int);
		void setScale(float);

		void pushVertex(char*);
		void pushTriangle(char*);

		private:
		float d_scale;
		int d_coordExchange; // 0:  none, 1:  swap Y and Z
	};


	// The stuff below this comment is overly designed for the SSEO demo, but I just ripped
	// if off of another project of mine.  You can consider it BSD licenced as well
	class Texture {
		public:
		Texture(GLuint type, GLuint id, std::string name = "", int = -1, int = -1);
		
		~Texture();
		void bind();
		std::string name();
		int width();
		int height();
		int channels();
		int channelSize();
		void *getData(size_t *size = NULL);
		void fillFloats(std::string);
		void fillFloats(float*);
		void writeToFile(std::string);
		GLuint getHandle();

		private:
		std::string d_name; 
		GLuint d_type, d_id;
		int d_width, d_height;
	};

	class Shader {
		public: 
		Shader(std::string name, std::string src, std::vector<std::string> outputs);
		std::string name();
		void activate();
		static std::string readSrc(std::string fileName);
		GLuint handle();

		void setVec2(std::string, float, float);

		protected: 

		private:
		std::string d_name;
		GLuint d_programHandle;

		friend class ShaderData;
	};


	class ShaderData {
		public:
		ShaderData(Shader*);
		~ShaderData();
		void addTexture(std::string, Texture*);
		void addVData(std::string varName, GLint type, int width, size_t length, void* data);
		void changeVData(std::string varName, void *data);
		void bind();
		Shader *shader();

		private:
		Shader *d_shader;
		GLuint d_vao;
		std::list<std::pair<std::string, Texture*> > d_textures;
		// Yes, you are now officially allowed to assassinate me.
		std::list<std::pair<std::pair<std::string, size_t>, GLuint> > d_vbufs;

		void pushVData(GLuint, size_t, void*); 
	};

	class ShaderPool {
		public:
		ShaderPool();
		Shader* getShader(std::string); 

		private:
		std::list<Shader*> d_shaders;
	};

	extern ShaderPool *g_defaultShaderPool;
};

#endif // _OPENGL_H
