in vec2 myTexCoord;
uniform sampler2D srcTex;
uniform sampler2D heightTex;

uniform vec2 borderFracs;

out vec4 color;

void main() {
	if (myTexCoord.x < borderFracs.x*0.5 || myTexCoord.x > 1.0 - borderFracs.x*0.5 ||
			myTexCoord.y < borderFracs.y*0.5 || myTexCoord.y > 1.0 - borderFracs.y*0.5)
		color = vec4(0.2, 0.4, 0.8, 1.0);
	else
		//gl_FragColor = vec4(1.0, texture(srcTex, myTexCoord).x, 1.0, 1.0);
		color = texture(heightTex, vec2(myTexCoord.x, 1.0 - myTexCoord.y)).x < 1.0 ?
		//color = texture(heightTex, vec2(myTexCoord.x, 1.0 - myTexCoord.y)).x != 1.324 ?
			clamp(texture(srcTex, myTexCoord).x, 0.0, 1.0)*vec4(1.0, 1.0, 1.0, 1.0) : 
			vec4(0.2, 0.4, 0.8, 1.0);
}
