in vec3 fragNorm;

in float Wc;
uniform vec2 winDims;

out vec4 screenDepthNormal;

void main() {
	float screenDepth = -Wc;
	vec3 screenNormal = normalize(fragNorm);

	vec2 relPos = vec2((gl_FragCoord.x - (winDims.x/2.0f))/winDims.x, 
			(gl_FragCoord.y - (winDims.y/2.0f))/winDims.x)*2.0f;

	// With this decision of relPos, our near plane is 1.0 away from the origo..
	vec3 camVec = normalize(vec3(relPos, -1.0f));
	if (dot(camVec, screenNormal.xyz) > 0.0)
		screenNormal = -screenNormal;

	screenDepthNormal = vec4(screenNormal, screenDepth);

	gl_FragDepth = gl_FragCoord.z;
}
