#ifndef _SHAREDSTRUCTS_H
#define _SHAREDSTRUCTS_H

#ifndef LANG_OPENCL
extern "C" {
#endif
	struct LineInfo {
		float2 startPos;
		float2 stepDir;

		int dirIndex;
		int numSteps;

		int idleSteps;
		int layerDistance; // In GPU:  Initial write pos

		int layerOffset; // In GPU:  myWriteAfter
		float tangent;
	};

	struct LineInfoD {
		double2 startPos;
		double2 stepDir;
		int dirIndex;
		int numSteps;
		int idleSteps;
		int myWriteAfter; // After how many steps there's need to write IN THIS THREAD
		int layerDistance;
		int layerOffset;
		float tangent;

		//struct LineInfoD *referenceLine; // FIXME:  This is only for generating opposites
	};

	// Parameters generated by saoParams kernel
	// to be used per-pixel in occlusion
	struct PixInfo {
		float2 dirStep;
		float2 pUpLocal;
		float thisContrib;
		int dir;
	};
#ifndef LANG_OPENCL
};
#endif

#endif // _SHAREDSTRUCTS_H
