#ifndef _SSEO_H
#define _SSEO_H

/* This is kept as simple as possible, and C compliant */
#include "hostTypes.h" // FIXME

#ifdef __cplusplus
extern "C" {
	namespace SSEO {
#endif
		// When normalTex == 0, the input height+normal map should be GL_TEXTURE_2D having 4 float channel, one mip map level
		// When normalTex != 0, depthNormalTex should have 1 float channel, and normalTex contain 4 channels (x, y, z, unused)
		// (These are checked for)

		// The output is an R32 float texture.
		// The projection array should contain elements (0,0), (1,1), (2,0), and (2,1) of the projection matrix; the rest are ignored.
		int init(unsigned int depthNormalTex, 
				unsigned int normalTex, 
				unsigned int resultLight, 
				float *projection, 
				int borderW, 
				int borderH,
				int K,
				float falloffDecay,
				GPGPU_Backend backend);
		void computeLight(bool report = true);
		void uninit();

		void *getResultBuf();
#ifdef __cplusplus
	};
};
#endif

#endif // _SSEO_H
