#ifndef _SWEEP_H
#define _SWEEP_H

#include <vector>
#include <string>

#include "kernelCommon.h"

#include "hostTypes.h"
#include "sharedConstants.h"

using namespace SSEO;
#include "sharedStructs.h"

//#define SKIPWRITES // Whether to skip writes that are unnecessary

#define ROTATE_HULL_POINTS // Use this, always
#define REGH3 // Have the third last convex hull element in a register

namespace SSEO {
	// This class generates information that determine work for the threads in the sweep phase
	class LineParams {
		public:
		LineParams(SSEOConfiguration*); //int width, int height, int dirs, int slants, float slantAngle = 0.0f); // FB dimensions
		//void setConfig(SSEOConfiguration*);
		void initSlants();
		void initPlain();

		struct LineInfo *getWork(size_t*);
		void removeLines(std::vector<struct LineInfo>*, int);
		int sweepWidth();
		int sweepHeight();
		std::vector<int> getDirOffsets();

		static std::string getLineInfo(const struct LineInfo);
		static std::string getLineInfoD(const struct LineInfoD);
		static bool lengthCompare(const struct LineInfoD &l1, const struct LineInfoD &l2);
		static bool offsetCompare(const struct LineInfoD &l1, const struct LineInfoD &l2);

		protected:
		SSEOConfiguration *d_config;
		/*int d_hfWidth, d_hfHeight;
		int d_layerDirs;*/
		double2 d_corners[4];
		double2 d_cornersOcc[4];
		//int d_dirs;
		std::vector<struct LineInfoD> d_workPool;
		std::vector<int> d_dirOffsets;
		int d_totalLineCount, d_maxDistance;
		int d_debug;
		int d_totalSteps;
		int d_concLength;

		int getSteps(double2, double2); // Returns the number of steps until step outside the HF
		int stepInside(double2, double2); // Steps until inside the HF.  If doesn't happen, returns -1
		int stepInsideOccNorm(double2, double2); // The same as above, but for Occ Box

		bool inside(double2, double2*); // Tests whether the point is inside the 4 vertices
		bool insideHF(double2);
		bool insideOcc(double2);
		void alignThreads(std::vector<struct LineInfoD>&, int); // Sorts and aligns -- final polishing before ready to be dispatched to the GPU
		void genOpposite();
		void genTangents();

		struct LineInfoD genOpposeLine(struct LineInfoD);
		void organizeIntoBlocks(std::vector<struct LineInfoD>*);
		void printBlock(std::vector<struct LineInfo>*, int);
	};

	// This one just generates the kernel sources
	class SweepKernel : public SSEOKernelSrc {
		public:
		SweepKernel();
		void genSrc();

		private:
		void genFuncs();
		void initKernel();

		void genOpti();

		void genOcclusion();
		void writeOut();

		void genBrute();
		/*void gatherBrute();
		void findMaxVec();*/

		void genHullInit();
		void genHullCompare();
		std::string genFalloff(std::string);
		std::string genOcc(std::string, std::string tanSin = "", std::string altSin = "", std::string upVec = "upVec");
		std::string genOccDot(std::string, std::string tanSin = "", std::string altSin = "", std::string upVec = "upVec");
		std::string genConvexOcc(std::string, std::string tanSin = "", std::string altSin = "");

		std::string thresholdCompare(std::string, std::string);

		void stepConvex(bool write = true);
		void stepConvexSimple(bool write);
		void stepConvexUnroll(bool write, std::string, std::string, std::string horOut = "");
		std::string hullRefCurrent();
		void hullIndexIncrement();
		void hullIndexDecrement();

		void sample(std::string pos, std::string dest, std::string tangentlDest = "", std::string upVecName = "upVec");
		void hybridSample(std::string pos, std::string dest, std::string tangentDest, std::string upVecName);
		void stepForward(bool doNotTouchIndex = false, bool decrementIdle = false);
		void genSampleFuncs();

		void initTangent();
		void postTangent();

		bool d_occlusionCompare; // Whether form the hull by convexity or by occlusion
		bool d_useFalloff;
		bool d_lookAhead;
	};
};

#endif // _SWEEP_H
