#include "sweep.h"

void SweepKernel::genBrute() {
	/*if (d_config->tangentType() != 0 && d_config->tangentType() != 3)
		throw std::string("Not impl");*/

	// Input:  startPos either li.startPos - li.stepDir (no lookahead), li.startPos - 2*li.stepDir
	// Traversal direction: li.stepDir
	// Output:  horVec
	if (d_config->mode() == 2) {
		append("float maxOcc = -1000000.0f;\n");
		append("float2 horVec;\n");

		//if (!d_config->tangentType())
			append("float maxSlope = %Ef;\n", d_config->fixedTangent());
	} else {
		if (d_config->tangentType()) {
			append("float maxSlope = tangentSin;\n");
			append("occlusion = tangentSin;\n");
		} else {
			append("float maxSlope = occlusion = %Ef;\n", d_config->fixedTangent());
		}
	}

	append("for (float2 stepPos = li.startPos - ");
	if (d_lookAhead) 
		append("2.0f*");
	append("li.stepDir; insideTex(stepPos); stepPos -= li.stepDir) {\n");
	incrementIndent();
	append("float2 samplePoint;\n");
	sample("stepPos", "samplePoint");
	append("float2 thisHorVec = samplePoint - pLocal;\n");
	append("float thisSlope = SSEOdot2(upVec, SSEOnormalize2(thisHorVec));\n");

	if (d_config->mode() == 2) {
		append("float thisOcc = " + genOcc("thisHorVec", "tangentSin") + ";\n");

		if (d_config->stopAtMax())
			append("if (thisOcc > maxOcc && thisSlope > maxSlope) {\n");
		else
			append("if (thisOcc > maxOcc) {\n");

		incrementIndent();
		append("maxOcc = thisOcc;\n");
		append("horVec = thisHorVec;\n");
		decrementIndent();
		append("}\n");

		if (d_config->stopAtMax())
			append("maxSlope = #maxf{maxSlope}{thisSlope}#;\n");

	} else {
		append("if (thisSlope > maxSlope) {\n");
		incrementIndent();

		append("occlusion += (thisSlope - maxSlope)*vecFalloff(thisHorVec);\n");
		//append("occlusion += " + genOcc("thisHorVec", "0.0f", "(thisSlope - maxSlope)") + ";\n");
		//append("occlusion -= " + genOcc("thisHorVec", "tangentSin", "(thisSlope - maxSlope)") + ";\n");
		append("maxSlope = thisSlope;\n");
		decrementIndent();
		append("}\n");
	}

	decrementIndent();
	append("}\n");

	//append("float2 horVec = #float2Ctor{0.0f}{0.0f}#;\n"); //convexHull[convexIndex-2] - pLocal;\n");
}
