#include "sweep.h"

void SweepKernel::sample(std::string pos, std::string dest, std::string tangentDest, std::string upVecName) {
	bool calculateTangent = tangentDest != "" && d_config->tangentType();

	if (d_config->tangentType() && d_config->stepInterpolation() == 2)
		throw std::string("Hybrid snap and tangent right now not supported");

	append("\n/* Taking a sample START */\n");
	static bool firstTime = true;
	if (d_config->occlusionScatter() && firstTime)
		append("float2 tempSnapCoord;\n"); // We need this during writeout
	firstTime = false;

	append("{\n");
	incrementIndent();

	if (d_config->stepInterpolation() == 2)
		hybridSample(pos, dest, tangentDest, upVecName);
	else {
		if (d_config->stepInterpolation() == 1) {
			std::string origSource = pos;
			/*if (snapTarget != "") {
				append("%s = ", snapTarget.c_str());
				source = snapTarget;
			} else {*/
				if (d_config->occlusionScatter())
					append("tempSnapCoord = ");
				else
					append("float2 tempSnapCoord = ");
				pos = "tempSnapCoord";
			//}
			append("snapCoord(%s);\n", origSource.c_str());

			/*if (!d_config->mode())
				append("thisSnapLength = SSEOdot2(%s, dirStep);\n", source.c_str());*/
		}

		std::string normalDest;
		if (calculateTangent)
			normalDest = "float2 normal";

		if (d_config->separateSources()) {
			append("float height = #tex2DSample1{depthTex}{%s.x}{%s.y}#;\n",
					pos.c_str(), pos.c_str());

			// If we are using normal tangent, we sample it from normalTex
			if (calculateTangent && d_config->tangentType() == 3) {
				append("float4 normalSample = #tex2DSample4{normalTex}{%s.x}{%s.y}#;\n",
						pos.c_str(), pos.c_str());
				append(normalDest + " = ");
				if (d_config->stepInterpolation() != 1)
					append("SSEOnormalize2(");
				append("#float2Ctor{normalSample.x*dirStep.x + normalSample.y*dirStep.y}{normalSample.z}#");
				if (d_config->stepInterpolation() != 1)
					append(")");
				append(";\n");
			}
		} else {
			append("float4 srcPixel = #tex2DSample4{depthNormalTex}{%s.x}{%s.y}#;\n", 
					pos.c_str(), pos.c_str());
			append("float height = srcPixel.w;\n");
			//if (d_tangent != 3) append("float2 "); // = SSEOnormalize2(#float2Ctor{srcPixel.x*dirStep.x + srcPixel.y*dirStep.y}{srcPixel.z}#);\n");
			if (calculateTangent && d_config->tangentType() == 3) {
				append(normalDest + " = ");
				if (d_config->stepInterpolation() != 1)
					append("SSEOnormalize2(");
				append("#float2Ctor{srcPixel.x*dirStep.x + srcPixel.y*dirStep.y}{srcPixel.z}#");
				if (d_config->stepInterpolation() != 1)
					append(")");
				append(";\n");
			}
			//append("normal = #float2Ctor{-normal.y}{normal.x}#;\n");
			//append("    float3 normal= #float3Ctor{srcPixel.x}{srcPixel.y}{srcPixel.z}#;\n");
		}

		float alpha = d_config->projMatrix().elem(0,0);
		float beta = d_config->projMatrix().elem(1,1);
		float A = d_config->projMatrix().elem(2,0);
		float B = d_config->projMatrix().elem(2,1);
		float a = (1.0f-A)/alpha;
		float b = -2.0f/((float)d_config->hfWidth()*alpha);
		float c = (1.0f-B)/beta;
		float d = -2.0f/((float)d_config->hfHeight()*beta);

		append("float2 projXY = #float2Ctor{%Ef + %s.x*%Ef}{%Ef + %s.y*%Ef}#;\n",
				a, pos.c_str(), (float)d_config->hfWidth()*b, 
				c, pos.c_str(), (float)d_config->hfHeight()*d);
		/*append("float2 pLocalTemp = #float2Ctor{(projXY.x*dirStep.x + projXY.y*dirStep.y)*height}{height}#;\n");
		append("%s = pLocalTemp;\n", dest.c_str());*/
		append("%s = #float2Ctor{(projXY.x*dirStep.x + projXY.y*dirStep.y)*height}{height}#;\n", dest.c_str());

		if (tangentDest != "" && upVecName != "") {
			append("%s = SSEOnormalize2(-%s);\n", upVecName.c_str(), dest.c_str());

			if (d_config->tangentType() && tangentDest != "NOTREALLYLOL") { // What a hack :D
				if (d_config->tangentType() == 2) {
					append("float2 tanBack = prevP - pLocal;\n");
					append("float2 tanForward = pLocal - nextP;\n");
					append("float2 tanVec = (SSEOdot2(tanBack, tanBack) < SSEOdot2(tanForward, tanForward)) ? tanBack : tanForward;\n");
				} else if (d_config->tangentType() == 1)
					append("float2 tanVec = prevP - nextP;\n");
				else {
					append("float2 tanVec = #float2Ctor{-normal.y}{normal.x}#;\n");
				}

				append("// If you're still convexing with occlusion, drag the occlusion v1 value here..\n");
				append("%s = SSEOdot2(%s, SSEOnormalize2(tanVec));\n", tangentDest.c_str(), upVecName.c_str());
			}
		}

	} // HybridSample
	decrementIndent();
	append("}\n");
	append("/* Taking a sample END */\n\n");
}

void SweepKernel::hybridSample(std::string pos, std::string dest, std::string tangentDest, std::string upVecName) {
	// Linear sample first..
	append("float2 texPos = %s;\n", pos.c_str());

	if (d_config->separateSources()) {
		append("float height = #tex2DSample1{depthTex}{texPos.x}{texPos.y}#;\n");
	} else {
		append("float4 srcPixel = #tex2DSample4{depthNormalTex}{texPos.x}{texPos.y}#;\n");
		append("float height = srcPixel.w;\n");
	}

	const float threshold = d_config->edgeThreshold();//1.005f;

	#if 0
	append("float thisDiff = fabsf(1.0f - __fdividef(prevHeight, height));\n");
	append("if (thisDiff > %Ef) {\n", threshold - 1.0f);
	#else
	append("if (height < prevHeight*%Ef || prevHeight < height*%Ef) {\n", 
		threshold, threshold);
	#endif
	incrementIndent();

	append("texPos = ");
	append("snapCoord(texPos);\n");

	// Snapped next
	if (d_config->separateSources()) {
		append("height = #tex2DSample1{depthTex}{texPos.x}{texPos.y}#;\n");
	} else {
		append("float4 srcPixel = #tex2DSample4{depthNormalTex}{texPos.x}{texPos.y}#;\n");
		append("height = srcPixel.w;\n");
	}
	decrementIndent();
	append("}\n");
	append("prevHeight = height;\n");


	float alpha = d_config->projMatrix().elem(0,0);
	float beta = d_config->projMatrix().elem(1,1);
	float A = d_config->projMatrix().elem(2,0);
	float B = d_config->projMatrix().elem(2,1);
	float a = (1.0f-A)/alpha;
	float b = -2.0f/((float)d_config->hfWidth()*alpha);
	float c = (1.0f-B)/beta;
	float d = -2.0f/((float)d_config->hfHeight()*beta);

	append("float2 projXY = #float2Ctor{%Ef + texPos.x*%Ef}{%Ef + texPos.y*%Ef}#;\n",
			a, (float)d_config->hfWidth()*b, 
			c, (float)d_config->hfHeight()*d);
	append("%s = #float2Ctor{(projXY.x*dirStep.x + projXY.y*dirStep.y)*height}{height}#;\n", dest.c_str());

	if (tangentDest != "" && upVecName != "")
		append("%s = SSEOnormalize2(-%s);\n", upVecName.c_str(), dest.c_str());


	#if 0
	// First we take a normal sample..
	append("float2 thisCoord = %s;\n", source.c_str());

	if (d_config->separateSources()) {
		append("float height = #tex2DSample1{depthTex}{thisCoord.x}{thisCoord.y}#;\n");
	} else {
		append("float height;\n");
		append("{\n");
		incrementIndent();
		append("float4 srcPixel = #tex2DSample4{depthNormalTex}{thisCoord.x}{thisCoord.y}#;\n");
		append("height = srcPixel.w;\n");
		if (d_tangent != 3) append("float2 ");
		append("normalNext = SSEOnormalize2(#float2Ctor{srcPixel.x*dirStep.x + srcPixel.y*dirStep.y}{srcPixel.z}#);\n");
		decrementIndent();
		append("}\n");
	}

	//append("float height = #tex2DSample1{depthTex}{thisCoord.x}{thisCoord.y}#;\n");

	// Then we see if it's within threshold (if not, snap sample)
	//append("occlusion = 0.0f;\n");
	//append("if (#absf{height - prevHeight}# > 0.1f) {\n");
	append("if (#absf{height - prevHeight}# > 0.05f) {\n");
	//append("if (#absf{height - prevHeight}# < 0.0f) {\n");
	append("  thisCoord = snapCoord(thisCoord);\n");

	if (d_config->separateSources()) {
		append("height = #tex2DSample1{depthTex}{thisCoord.x}{thisCoord.y}#;\n");
	} else {
		append("{\n");
		incrementIndent();
		append("float4 srcPixel = #tex2DSample4{depthNormalTex}{thisCoord.x}{thisCoord.y}#;\n");
		append("height = srcPixel.w;\n");
		if (d_tangent != 3) append("float2 ");
		append("normalNext = SSEOnormalize2(#float2Ctor{srcPixel.x*dirStep.x + srcPixel.y*dirStep.y}{srcPixel.z}#);\n");
		decrementIndent();
		append("}\n");
	}

	//append("  height = #tex2DSample1{depthTex}{thisCoord.x}{thisCoord.y}#;\n");
	//append("  occlusion = 1.0f;\n");
	append("}\n");
	append("prevHeight = height;\n");

	float alpha = d_config->projMatrix().elem(0,0);
	float beta = d_config->projMatrix().elem(1,1);
	float A = d_config->projMatrix().elem(2,0);
	float B = d_config->projMatrix().elem(2,1);
	float a = (1.0f-A)/alpha;
	float b = -2.0f/((float)d_config->hfWidth()*alpha);
	float c = (1.0f-B)/beta;
	float d = -2.0f/((float)d_config->hfHeight()*beta);

	append("float2 projXY = #float2Ctor{%Ef + thisCoord.x*%Ef}{%Ef + thisCoord.y*%Ef}#;\n",
			a, (float)d_config->hfWidth()*b, 
			c, (float)d_config->hfHeight()*d);
	append("%s = #float2Ctor{(projXY.x*dirStep.x + projXY.y*dirStep.y)*height}{height}#;\n",
			target.c_str());
	
	decrementIndent();
	append("}\n");
	#endif
}

void SweepKernel::stepForward(bool doNotTouchIndex, bool decrementIdle) {
	append("\n/* Stepping forward START */\n");
	append("li.numSteps--;\n");
	if (decrementIdle)
		append("li.idleSteps--;\n");
	append("li.startPos += li.stepDir;\n");
	if (!doNotTouchIndex) {
		if (d_config->sweepSurface()) {
			append("storeY += (li.dirIndex < %d) ? 1 : -1;\n", d_config->dirs()/2);
		} else {
			if (d_config->matchOpposite()) {
				append("destIndex += myStripe;\n");
			} else
				append("destIndex += %d;\n", d_config->sweepWidth());
		}
	}
	append("/* Stepping forward END */\n\n");
}

void SweepKernel::genSampleFuncs() {
	if (d_config->stepInterpolation() == 1 || d_config->stepInterpolation() == 2) {
		append("#funcDecl{snapCoord}{float2}{const float2 in}# {\n");
		append("  return #float2Ctor{(float)((int)(in.x*%Ef))*%Ef + %Ef}{(float)((int)(in.y*%Ef))*%Ef + %Ef}#;\n",
				(float)d_config->hfWidth(),
				1.0f/(float)d_config->hfWidth(), 0.5f/(float)d_config->hfWidth(),
				(float)d_config->hfHeight(),
				1.0f/(float)d_config->hfHeight(), 0.5f/(float)d_config->hfHeight());
		append("}\n\n");
	}
}
